--  JOB DUOMENU SCRIPT v1.2

-- OPEN MENU
function openmenu(menu)
	menu:show()
end

---------------
-- MAIN --
---------------
if not inGame() then
	add_job = add_job or function(data)
		local difficulty_id = tweak_data:difficulty_to_index( data.difficulty )
		table.insert( managers.crimenet._presets, { job_id = data.job_id, difficulty_id = difficulty_id, difficulty = data.difficulty, chance = 1 } )
		managers.crimenet._MAX_ACTIVE_JOBS = managers.crimenet._MAX_ACTIVE_JOBS + 1
	end
	
	-- ADD ALL NORMAL MISSIONS ON CRIMENET
	addnormmis = addnormmis or function()
		managers.crimenet._NEW_JOB_MIN_TIME = 0
		managers.crimenet._NEW_JOB_MAX_TIME = 0
		managers.crimenet._presets = { }
		managers.crimenet._active_jobs = { }
		managers.crimenet._MAX_ACTIVE_JOBS = 0
		add_job({difficulty = "normal", job_id = "welcome_to_the_jungle_prof"})
		add_job({difficulty = "normal", job_id = "framing_frame"})
		add_job({difficulty = "normal", job_id = "branchbank_prof"})
		add_job({difficulty = "normal", job_id = "branchbank_gold"})
		add_job({difficulty = "normal", job_id = "branchbank_cash"})
		add_job({difficulty = "normal", job_id = "branchbank_deposit"})
		add_job({difficulty = "normal", job_id = "ukrainian_job_prof"})
		add_job({difficulty = "normal", job_id = "watchdogs"})
		add_job({difficulty = "normal", job_id = "alex"})
		add_job({difficulty = "normal", job_id = "firestarter"})
		add_job({difficulty = "normal", job_id = "jewelry_store"})
		add_job({difficulty = "normal", job_id = "four_stores"})	
		add_job({difficulty = "normal", job_id = "nightclub"})
		add_job({difficulty = "normal", job_id = "mallcrasher"})
		--add_job({difficulty = "normal", job_id = "family"})	
		add_job({difficulty = "normal", job_id = "arm_for"})
		add_job({difficulty = "normal", job_id = "arm_hcm"})
		add_job({difficulty = "normal", job_id = "arm_cro"})
		add_job({difficulty = "normal", job_id = "arm_fac"})
		add_job({difficulty = "normal", job_id = "arm_par"})
		add_job({difficulty = "normal", job_id = "arm_und"})
		add_job({difficulty = "normal", job_id = "roberts"})
		--add_job({difficulty = "normal", job_id = "heat"}) --NOT YET
		--add_job({difficulty = "normal", job_id = "haunted"}) --NOT YET
		--add_job({difficulty = "normal", job_id = "big"}) --NOT YET
		--add_job({difficulty = "normal", job_id = "monolithic_1"}) --NOT YET
		--add_job({difficulty = "normal", job_id = "branchbank_cloaker"}) --NOT YET
		add_job({difficulty = "normal", job_id = "election_day"})
		add_job({difficulty = "normal", job_id = "election_day_prof"})
		add_job({difficulty = "normal", job_id = "watchdogs_prof"})
		add_job({difficulty = "normal", job_id = "alex_prof"})
		add_job({difficulty = "normal", job_id = "firestarter_prof"})
		add_job({difficulty = "normal", job_id = "branchbank_gold_prof"})
		add_job({difficulty = "normal", job_id = "framing_frame_prof"})
		--add_job({difficulty = "normal", job_id = ""}) --NOT YET
	end
	-- ADD ALL HARD MISSIONS ON CRIMENET
	addhardmis = addhardmis or function()
		managers.crimenet._NEW_JOB_MIN_TIME = 0
		managers.crimenet._NEW_JOB_MAX_TIME = 0
		managers.crimenet._presets = { }
		managers.crimenet._active_jobs = { }
		managers.crimenet._MAX_ACTIVE_JOBS = 0
		add_job({difficulty = "hard", job_id = "welcome_to_the_jungle_prof"})
		add_job({difficulty = "hard", job_id = "framing_frame"})
		add_job({difficulty = "hard", job_id = "branchbank_prof"})
		--add_job({difficulty = "hard", job_id = "branchbank_gold"})
		add_job({difficulty = "hard", job_id = "branchbank_cash"})
		add_job({difficulty = "hard", job_id = "branchbank_deposit"})
		add_job({difficulty = "hard", job_id = "ukrainian_job_prof"})
		add_job({difficulty = "hard", job_id = "watchdogs"})
		add_job({difficulty = "hard", job_id = "alex"})
		add_job({difficulty = "hard", job_id = "firestarter"})
		add_job({difficulty = "hard", job_id = "jewelry_store"})
		add_job({difficulty = "hard", job_id = "four_stores"})	
		add_job({difficulty = "hard", job_id = "nightclub"})
		add_job({difficulty = "hard", job_id = "mallcrasher"})
		add_job({difficulty = "hard", job_id = "family"})
		--add_job({difficulty = "hard", job_id = "arm_for"})
		add_job({difficulty = "hard", job_id = "arm_hcm"})
		add_job({difficulty = "hard", job_id = "arm_cro"})
		add_job({difficulty = "hard", job_id = "arm_fac"})
		add_job({difficulty = "hard", job_id = "arm_par"})
		add_job({difficulty = "hard", job_id = "arm_und"})
		add_job({difficulty = "hard", job_id = "roberts"})
		add_job({difficulty = "hard", job_id = "election_day"})
		add_job({difficulty = "hard", job_id = "election_day_prof"})
		add_job({difficulty = "hard", job_id = "watchdogs_prof"})
		add_job({difficulty = "hard", job_id = "alex_prof"})
		add_job({difficulty = "hard", job_id = "firestarter_prof"})
		add_job({difficulty = "hard", job_id = "branchbank_gold_prof"})
		add_job({difficulty = "hard", job_id = "framing_frame_prof"})
	end
	-- ADD ALL VERY HARD MISSIONS ON CRIMENET
	addvhardmis = addvhardmis or function()
		managers.crimenet._NEW_JOB_MIN_TIME = 0
		managers.crimenet._NEW_JOB_MAX_TIME = 0
		managers.crimenet._presets = { }
		managers.crimenet._active_jobs = { }
		managers.crimenet._MAX_ACTIVE_JOBS = 0
		add_job({difficulty = "overkill", job_id = "welcome_to_the_jungle_prof"})
		add_job({difficulty = "overkill", job_id = "framing_frame"})
		add_job({difficulty = "overkill", job_id = "branchbank_prof"})
		--add_job({difficulty = "overkill", job_id = "branchbank_gold"})
		add_job({difficulty = "overkill", job_id = "branchbank_cash"})
		add_job({difficulty = "overkill", job_id = "branchbank_deposit"})
		add_job({difficulty = "overkill", job_id = "ukrainian_job_prof"})
		add_job({difficulty = "overkill", job_id = "watchdogs"})
		add_job({difficulty = "overkill", job_id = "alex"})
		add_job({difficulty = "overkill", job_id = "firestarter"})
		add_job({difficulty = "overkill", job_id = "jewelry_store"})
		add_job({difficulty = "overkill", job_id = "four_stores"})	
		add_job({difficulty = "overkill", job_id = "nightclub"})
		add_job({difficulty = "overkill", job_id = "mallcrasher"})
		add_job({difficulty = "overkill", job_id = "family"})
		--add_job({difficulty = "overkill", job_id = "arm_for"})
		add_job({difficulty = "overkill", job_id = "arm_hcm"})
		add_job({difficulty = "overkill", job_id = "arm_cro"})
		add_job({difficulty = "overkill", job_id = "arm_fac"})
		add_job({difficulty = "overkill", job_id = "arm_par"})
		add_job({difficulty = "overkill", job_id = "arm_und"})
		add_job({difficulty = "overkill", job_id = "roberts"})
		add_job({difficulty = "overkill", job_id = "election_day"})
		add_job({difficulty = "overkill", job_id = "election_day_prof"})
		add_job({difficulty = "overkill", job_id = "watchdogs_prof"})
		add_job({difficulty = "overkill", job_id = "alex_prof"})
		add_job({difficulty = "overkill", job_id = "firestarter_prof"})
		add_job({difficulty = "overkill", job_id = "branchbank_gold_prof"})
		add_job({difficulty = "overkill", job_id = "framing_frame_prof"})
	end	
	-- ADD ALL OVERKILL MISSIONS ON CRIMENET
	addovermis = addovermis or function()
		managers.crimenet._NEW_JOB_MIN_TIME = 0
		managers.crimenet._NEW_JOB_MAX_TIME = 0
		managers.crimenet._presets = { }
		managers.crimenet._active_jobs = { }
		managers.crimenet._MAX_ACTIVE_JOBS = 0
		add_job({difficulty = "overkill_145", job_id = "welcome_to_the_jungle_prof"}) -- Big Oil
		add_job({difficulty = "overkill_145", job_id = "framing_frame"})
		add_job({difficulty = "overkill_145", job_id = "branchbank_prof"})
		--add_job({difficulty = "overkill_145", job_id = "branchbank_gold"})
		add_job({difficulty = "overkill_145", job_id = "branchbank_cash"})
		add_job({difficulty = "overkill_145", job_id = "branchbank_deposit"})
		add_job({difficulty = "overkill_145", job_id = "ukrainian_job_prof"})
		add_job({difficulty = "overkill_145", job_id = "watchdogs"})
		add_job({difficulty = "overkill_145", job_id = "alex"}) -- Rats
		add_job({difficulty = "overkill_145", job_id = "firestarter"})
		add_job({difficulty = "overkill_145", job_id = "jewelry_store"})
		add_job({difficulty = "overkill_145", job_id = "four_stores"})	
		add_job({difficulty = "overkill_145", job_id = "nightclub"})
		add_job({difficulty = "overkill_145", job_id = "mallcrasher"})
		add_job({difficulty = "overkill_145", job_id = "family"}) -- Diamond store
		--add_job({difficulty = "overkill_145", job_id = "arm_for"}) -- TRAIN
		add_job({difficulty = "overkill_145", job_id = "arm_hcm"}) -- Downtown
		add_job({difficulty = "overkill_145", job_id = "arm_cro"}) -- Crossroad
		add_job({difficulty = "overkill_145", job_id = "arm_fac"}) -- Harbor
		add_job({difficulty = "overkill_145", job_id = "arm_par"}) -- Park
		add_job({difficulty = "overkill_145", job_id = "arm_und"}) -- Underpass
		add_job({difficulty = "overkill_145", job_id = "roberts"}) -- Charlie Santa heist
		add_job({difficulty = "overkill_145", job_id = "election_day"})
		add_job({difficulty = "overkill_145", job_id = "election_day_prof"})
		add_job({difficulty = "overkill_145", job_id = "watchdogs_prof"})
		add_job({difficulty = "overkill_145", job_id = "alex_prof"})
		add_job({difficulty = "overkill_145", job_id = "firestarter_prof"})
		add_job({difficulty = "overkill_145", job_id = "branchbank_gold_prof"})
		add_job({difficulty = "overkill_145", job_id = "framing_frame_prof"})
		PlayMedia("trainer/media/effects/ballsofsteel.mp3")
	end
		-- ADD ALL OVERKILL MISSIONS ON CRIMENET
	addhellrmis = addhellrmis or function()
		managers.crimenet._NEW_JOB_MIN_TIME = 0
		managers.crimenet._NEW_JOB_MAX_TIME = 0
		managers.crimenet._presets = { }
		managers.crimenet._active_jobs = { }
		managers.crimenet._MAX_ACTIVE_JOBS = 0
		add_job({difficulty = "overkill_290", job_id = "welcome_to_the_jungle_prof"}) -- Big Oil
		add_job({difficulty = "overkill_290", job_id = "framing_frame"})
		add_job({difficulty = "overkill_290", job_id = "branchbank_prof"})
		--add_job({difficulty = "overkill_290", job_id = "branchbank_gold"})
		add_job({difficulty = "overkill_290", job_id = "branchbank_cash"})
		add_job({difficulty = "overkill_290", job_id = "branchbank_deposit"})
		add_job({difficulty = "overkill_290", job_id = "ukrainian_job_prof"})
		add_job({difficulty = "overkill_290", job_id = "watchdogs"})
		add_job({difficulty = "overkill_290", job_id = "alex"}) -- Rats
		add_job({difficulty = "overkill_290", job_id = "firestarter"})
		add_job({difficulty = "overkill_290", job_id = "jewelry_store"})
		add_job({difficulty = "overkill_290", job_id = "four_stores"})	
		add_job({difficulty = "overkill_290", job_id = "nightclub"})
		add_job({difficulty = "overkill_290", job_id = "mallcrasher"})
		add_job({difficulty = "overkill_290", job_id = "family"}) -- Diamond store
		--add_job({difficulty = "overkill_290", job_id = "arm_for"}) -- TRAIN / CRASHES
		add_job({difficulty = "overkill_290", job_id = "arm_hcm"}) -- Downtown
		add_job({difficulty = "overkill_290", job_id = "arm_cro"}) -- Crossroad
		add_job({difficulty = "overkill_290", job_id = "arm_fac"}) -- Harbor
		add_job({difficulty = "overkill_290", job_id = "arm_par"}) -- Park
		add_job({difficulty = "overkill_290", job_id = "arm_und"}) -- Underpass
		add_job({difficulty = "overkill_290", job_id = "roberts"}) -- Charlie Santa heist
		add_job({difficulty = "overkill_290", job_id = "election_day"})
		add_job({difficulty = "overkill_290", job_id = "election_day_prof"})
		add_job({difficulty = "overkill_290", job_id = "watchdogs_prof"})
		add_job({difficulty = "overkill_290", job_id = "alex_prof"})
		add_job({difficulty = "overkill_290", job_id = "firestarter_prof"})
		add_job({difficulty = "overkill_290", job_id = "branchbank_gold_prof"})
		add_job({difficulty = "overkill_290", job_id = "framing_frame_prof"})
		PlayMedia("trainer/media/effects/ballsofsteel.mp3")
	end
	
	-- ADD ALL OVERKILL MISSIONS ON CRIMENET
	addonlyproffmis = addonlyproffmis or function()
		managers.crimenet._NEW_JOB_MIN_TIME = 0
		managers.crimenet._NEW_JOB_MAX_TIME = 0
		managers.crimenet._presets = { }
		managers.crimenet._active_jobs = { }
		managers.crimenet._MAX_ACTIVE_JOBS = 50
		add_job({difficulty = "normal", job_id = "welcome_to_the_jungle_prof"})
		add_job({difficulty = "normal", job_id = "branchbank_prof"})
		add_job({difficulty = "normal", job_id = "branchbank_gold_prof"})
		add_job({difficulty = "normal", job_id = "ukrainian_job_prof"})
		add_job({difficulty = "normal", job_id = "election_day_prof"})
		add_job({difficulty = "normal", job_id = "watchdogs_prof"})
		add_job({difficulty = "normal", job_id = "alex_prof"})
		add_job({difficulty = "normal", job_id = "firestarter_prof"})
		add_job({difficulty = "normal", job_id = "framing_frame_prof"})
		add_job({difficulty = "hard", job_id = "welcome_to_the_jungle_prof"})
		add_job({difficulty = "hard", job_id = "branchbank_prof"})
		add_job({difficulty = "hard", job_id = "branchbank_gold_prof"})
		add_job({difficulty = "hard", job_id = "ukrainian_job_prof"})
		add_job({difficulty = "hard", job_id = "election_day_prof"})
		add_job({difficulty = "hard", job_id = "watchdogs_prof"})
		add_job({difficulty = "hard", job_id = "alex_prof"})
		add_job({difficulty = "hard", job_id = "firestarter_prof"})
		add_job({difficulty = "hard", job_id = "framing_frame_prof"})
		add_job({difficulty = "overkill", job_id = "welcome_to_the_jungle_prof"})
		add_job({difficulty = "overkill", job_id = "branchbank_prof"})
		add_job({difficulty = "overkill", job_id = "branchbank_gold_prof"})
		add_job({difficulty = "overkill", job_id = "ukrainian_job_prof"})
		add_job({difficulty = "overkill", job_id = "election_day_prof"})
		add_job({difficulty = "overkill", job_id = "watchdogs_prof"})
		add_job({difficulty = "overkill", job_id = "alex_prof"})
		add_job({difficulty = "overkill", job_id = "firestarter_prof"})
		add_job({difficulty = "overkill", job_id = "framing_frame_prof"})
		add_job({difficulty = "overkill_145", job_id = "welcome_to_the_jungle_prof"})
		add_job({difficulty = "overkill_145", job_id = "branchbank_prof"})
		add_job({difficulty = "overkill_145", job_id = "branchbank_gold_prof"})
		add_job({difficulty = "overkill_145", job_id = "ukrainian_job_prof"})
		add_job({difficulty = "overkill_145", job_id = "election_day_prof"})
		add_job({difficulty = "overkill_145", job_id = "watchdogs_prof"})
		add_job({difficulty = "overkill_145", job_id = "alex_prof"})
		add_job({difficulty = "overkill_145", job_id = "firestarter_prof"})
		add_job({difficulty = "overkill_145", job_id = "framing_frame_prof"})
		add_job({difficulty = "overkill_290", job_id = "welcome_to_the_jungle_prof"})
		add_job({difficulty = "overkill_290", job_id = "branchbank_prof"})
		add_job({difficulty = "overkill_290", job_id = "branchbank_gold_prof"})
		add_job({difficulty = "overkill_290", job_id = "ukrainian_job_prof"})
		add_job({difficulty = "overkill_290", job_id = "election_day_prof"})
		add_job({difficulty = "overkill_290", job_id = "watchdogs_prof"})
		add_job({difficulty = "overkill_290", job_id = "alex_prof"})
		add_job({difficulty = "overkill_290", job_id = "firestarter_prof"})
		add_job({difficulty = "overkill_290", job_id = "framing_frame_prof"})
		PlayMedia("trainer/media/effects/yourthebest.mp3")
	end
	
	-- RANDOM STEALTH MISSION
	randomstealth = randomstealth or function()
		local stealthmiss = { "four_stores", "nightclub", "ukrainian_job_prof", "framing_frame_prof", "welcome_to_the_jungle_prof", "firestarter_prof", "jewelry_store", "branchbank_prof", "family", "roberts", "election_day" }
        add_job({ job_id = stealthmiss[math.random(1, #stealthmiss)], difficulty = "overkill_145"})
	end
	
	-- FREE JOB PURCHASE
	freejob = freejob or function()
		function MoneyManager:get_cost_of_premium_contract(job_id, difficulty) return 0 
		end
		PlayMedia("trainer/media/effects/chaching.mp3")
	end
	
	-- CUSTOM LOBBIES
	-- CREATE LOBBY FOR OVERKILL MULTIDAY MISSIONS
	misframe = function()
		managers.job:activate_job ( "framing_frame_prof" )
		Global.game_settings.level_id = "framing_frame_1"
		Global.game_settings.mission = managers.job:current_mission()
		Global.game_settings.difficulty = "overkill_145"
		local level_id = tweak_data.levels:get_index_from_level_id( Global.game_settings.level_id )
		local job_id = tweak_data.narrative:get_index_from_job_id( managers.job:current_job_id() )
		managers.network.matchmake:create_lobby( { numbers = { level_id, "overkill_145", "friends", nil, nil, 1, 1, 1 } } )
	end
	misframe2 = function()
		managers.job:activate_job ( "framing_frame_prof" )
		Global.game_settings.level_id = "framing_frame_2"
		Global.game_settings.mission = managers.job:current_mission()
		Global.game_settings.difficulty = "overkill_145"
		local level_id = tweak_data.levels:get_index_from_level_id( Global.game_settings.level_id )
		local job_id = tweak_data.narrative:get_index_from_job_id( managers.job:current_job_id() )
		managers.network.matchmake:create_lobby( { numbers = { level_id, "overkill_145", "friends", nil, nil, 1, 1, 1 } } )
	end
	misframe3 = function()
		managers.job:activate_job ( "framing_frame_prof" )
		Global.game_settings.level_id = "framing_frame_3"
		Global.game_settings.mission = managers.job:current_mission()
		Global.game_settings.difficulty = "overkill_145"
		local level_id = tweak_data.levels:get_index_from_level_id( Global.game_settings.level_id )
		local job_id = tweak_data.narrative:get_index_from_job_id( managers.job:current_job_id() )
		managers.network.matchmake:create_lobby( { numbers = { level_id, "overkill_145", "friends", nil, nil, 1, 1, 1 } } )
	end
	misrats = function()
		managers.job:activate_job ( "alex" )
		Global.game_settings.level_id = "alex_1"
		Global.game_settings.mission = managers.job:current_mission()
		Global.game_settings.difficulty = "overkill_145"
		local level_id = tweak_data.levels:get_index_from_level_id( Global.game_settings.level_id )
		local job_id = tweak_data.narrative:get_index_from_job_id( managers.job:current_job_id() )
		managers.network.matchmake:create_lobby( { numbers = { level_id, "overkill_145", "friends", nil, nil, 1, 1, 1 } } )
	end
	misrats2 = function()
		managers.job:activate_job ( "alex" )
		Global.game_settings.level_id = "alex_2"
		Global.game_settings.mission = managers.job:current_mission()
		Global.game_settings.difficulty = "overkill_145"
		local level_id = tweak_data.levels:get_index_from_level_id( Global.game_settings.level_id )
		local job_id = tweak_data.narrative:get_index_from_job_id( managers.job:current_job_id() )
		managers.network.matchmake:create_lobby( { numbers = { level_id, "overkill_145", "friends", nil, nil, 1, 1, 1 } } )
	end
	misrats3 = function()
		managers.job:activate_job ( "alex" )
		Global.game_settings.level_id = "alex_3"
		Global.game_settings.mission = managers.job:current_mission()
		Global.game_settings.difficulty = "overkill_145"
		local level_id = tweak_data.levels:get_index_from_level_id( Global.game_settings.level_id )
		local job_id = tweak_data.narrative:get_index_from_job_id( managers.job:current_job_id() )
		managers.network.matchmake:create_lobby( { numbers = { level_id, "overkill_145", "friends", nil, nil, 1, 1, 1 } } )
	end
	miswatch = function()
		managers.job:activate_job ( "watchdogs" )
		Global.game_settings.level_id = "watchdogs_1"
		Global.game_settings.mission = managers.job:current_mission()
		Global.game_settings.difficulty = "overkill_145"
		local level_id = tweak_data.levels:get_index_from_level_id( Global.game_settings.level_id )
		local job_id = tweak_data.narrative:get_index_from_job_id( managers.job:current_job_id() )
		managers.network.matchmake:create_lobby( { numbers = { level_id, "overkill_145", "friends", nil, nil, 1, 1, 1 } } )
	end
	miswatch2 = function()
		managers.job:activate_job ( "watchdogs" )
		Global.game_settings.level_id = "watchdogs_2"
		Global.game_settings.mission = managers.job:current_mission()
		Global.game_settings.difficulty = "overkill_145"
		local level_id = tweak_data.levels:get_index_from_level_id( Global.game_settings.level_id )
		local job_id = tweak_data.narrative:get_index_from_job_id( managers.job:current_job_id() )
		managers.network.matchmake:create_lobby( { numbers = { level_id, "overkill_145", "friends", nil, nil, 1, 1, 1 } } )
	end
	misfire = function()
		managers.job:activate_job ( "firestarter" )
		Global.game_settings.level_id = "firestarter_1"
		Global.game_settings.mission = managers.job:current_mission()
		Global.game_settings.difficulty = "overkill_145"
		local level_id = tweak_data.levels:get_index_from_level_id( Global.game_settings.level_id )
		local job_id = tweak_data.narrative:get_index_from_job_id( managers.job:current_job_id() )
		managers.network.matchmake:create_lobby( { numbers = { level_id, "overkill_145", "friends", nil, nil, 1, 1, 1 } } )
	end
	misfire2 = function()
		managers.job:activate_job ( "firestarter" )
		Global.game_settings.level_id = "firestarter_2"
		Global.game_settings.mission = managers.job:current_mission()
		Global.game_settings.difficulty = "overkill_145"
		local level_id = tweak_data.levels:get_index_from_level_id( Global.game_settings.level_id )
		local job_id = tweak_data.narrative:get_index_from_job_id( managers.job:current_job_id() )
		managers.network.matchmake:create_lobby( { numbers = { level_id, "overkill_145", "friends", nil, nil, 1, 1, 1 } } )
	end
	misfire3 = function()
		managers.job:activate_job ( "firestarter" )
		Global.game_settings.level_id = "firestarter_3"
		Global.game_settings.mission = managers.job:current_mission()
		Global.game_settings.difficulty = "overkill_145"
		local level_id = tweak_data.levels:get_index_from_level_id( Global.game_settings.level_id )
		local job_id = tweak_data.narrative:get_index_from_job_id( managers.job:current_job_id() )
		managers.network.matchmake:create_lobby( { numbers = { level_id, "overkill_145", "friends", nil, nil, 1, 1, 1 } } )
	end
	misbigoil = function()
		managers.job:activate_job ( "welcome_to_the_jungle_prof" )
		Global.game_settings.level_id = "welcome_to_the_jungle_1"
		Global.game_settings.mission = managers.job:current_mission()
		Global.game_settings.difficulty = "overkill_145"
		local level_id = tweak_data.levels:get_index_from_level_id( Global.game_settings.level_id )
		local job_id = tweak_data.narrative:get_index_from_job_id( managers.job:current_job_id() )
		managers.network.matchmake:create_lobby( { numbers = { level_id, "overkill_145", "friends", nil, nil, 1, 1, 1 } } )
	end
	misbigoil2 = function()
		managers.job:activate_job ( "welcome_to_the_jungle_prof" )
		Global.game_settings.level_id = "welcome_to_the_jungle_2"
		Global.game_settings.mission = managers.job:current_mission()
		Global.game_settings.difficulty = "overkill_145"
		local level_id = tweak_data.levels:get_index_from_level_id( Global.game_settings.level_id )
		local job_id = tweak_data.narrative:get_index_from_job_id( managers.job:current_job_id() )
		managers.network.matchmake:create_lobby( { numbers = { level_id, "overkill_145", "friends", nil, nil, 1, 1, 1 } } )
	end
	-- ELECTION DAY
	miselect = function()
		managers.job:activate_job ( "election_day" )
		Global.game_settings.level_id = "election_day_1"
		Global.game_settings.mission = managers.job:current_mission()
		Global.game_settings.difficulty = "overkill_145"
		local level_id = tweak_data.levels:get_index_from_level_id( Global.game_settings.level_id )
		local job_id = tweak_data.narrative:get_index_from_job_id( managers.job:current_job_id() )
		managers.network.matchmake:create_lobby( { numbers = { level_id, "overkill_145", "friends", nil, nil, 1, 1, 1 } } )
	end
	miselect2 = function()
		managers.job:activate_job ( "election_day" )
		Global.game_settings.level_id = "election_day_2"
		Global.game_settings.mission = managers.job:current_mission()
		Global.game_settings.difficulty = "overkill_145"
		local level_id = tweak_data.levels:get_index_from_level_id( Global.game_settings.level_id )
		local job_id = tweak_data.narrative:get_index_from_job_id( managers.job:current_job_id() )
		managers.network.matchmake:create_lobby( { numbers = { level_id, "overkill_145", "friends", nil, nil, 1, 1, 1 } } )
	end
	miselect3 = function()
		managers.job:activate_job ( "election_day" )
		Global.game_settings.level_id = "election_day_3"
		Global.game_settings.mission = managers.job:current_mission()
		Global.game_settings.difficulty = "overkill_145"
		local level_id = tweak_data.levels:get_index_from_level_id( Global.game_settings.level_id )
		local job_id = tweak_data.narrative:get_index_from_job_id( managers.job:current_job_id() )
		managers.network.matchmake:create_lobby( { numbers = { level_id, "overkill_145", "friends", nil, nil, 1, 1, 1 } } )
	end

	-- CREATE LOBBY FOR OVERKILL SINGLEDAY MISSIONS
	misbankg = function()
		managers.job:activate_job ( "branchbank_gold_prof" )
		Global.game_settings.level_id = "branchbank"
		Global.game_settings.mission = managers.job:current_mission()
		Global.game_settings.difficulty = "overkill_145"
		local level_id = tweak_data.levels:get_index_from_level_id( Global.game_settings.level_id )
		local job_id = tweak_data.narrative:get_index_from_job_id( managers.job:current_job_id() )
		managers.network.matchmake:create_lobby( { numbers = { level_id, "overkill_145", "friends", nil, nil, 1, 1, 1 } } )
	end
	misbankc = function()
		managers.job:activate_job ( "branchbank_cash" )
		Global.game_settings.level_id = "branchbank"
		Global.game_settings.mission = managers.job:current_mission()
		Global.game_settings.difficulty = "overkill_145"
		local level_id = tweak_data.levels:get_index_from_level_id( Global.game_settings.level_id )
		local job_id = tweak_data.narrative:get_index_from_job_id( managers.job:current_job_id() )
		managers.network.matchmake:create_lobby( { numbers = { level_id, "overkill_145", "friends", nil, nil, 1, 1, 1 } } )
	end
	misbanks = function()
		managers.job:activate_job ( "branchbank_prof" )
		Global.game_settings.level_id = "branchbank"
		Global.game_settings.mission = managers.job:current_mission()
		Global.game_settings.difficulty = "overkill_145"
		local level_id = tweak_data.levels:get_index_from_level_id( Global.game_settings.level_id )
		local job_id = tweak_data.narrative:get_index_from_job_id( managers.job:current_job_id() )
		managers.network.matchmake:create_lobby( { numbers = { level_id, "overkill_145", "friends", nil, nil, 1, 1, 1 } } )
	end
	misbankd = function()
		managers.job:activate_job ( "branchbank_deposit" )
		Global.game_settings.level_id = "branchbank"
		Global.game_settings.mission = managers.job:current_mission()
		Global.game_settings.difficulty = "overkill_145"
		local level_id = tweak_data.levels:get_index_from_level_id( Global.game_settings.level_id )
		local job_id = tweak_data.narrative:get_index_from_job_id( managers.job:current_job_id() )
		managers.network.matchmake:create_lobby( { numbers = { level_id, "overkill_145", "friends", nil, nil, 1, 1, 1 } } )
	end
	misfamily = function()
		managers.job:activate_job ( "family" )
		Global.game_settings.level_id = "family"
		Global.game_settings.mission = managers.job:current_mission()
		Global.game_settings.difficulty = "overkill_145"
		local level_id = tweak_data.levels:get_index_from_level_id( Global.game_settings.level_id )
		local job_id = tweak_data.narrative:get_index_from_job_id( managers.job:current_job_id() )
		managers.network.matchmake:create_lobby( { numbers = { level_id, "overkill_145", "friends", nil, nil, 1, 1, 1 } } )
	end
	misfour = function()
		managers.job:activate_job ( "four_stores" )
		Global.game_settings.level_id = "four_stores"
		Global.game_settings.mission = managers.job:current_mission()
		Global.game_settings.difficulty = "overkill_145"
		local level_id = tweak_data.levels:get_index_from_level_id( Global.game_settings.level_id )
		local job_id = tweak_data.narrative:get_index_from_job_id( managers.job:current_job_id() )
		managers.network.matchmake:create_lobby( { numbers = { level_id, "overkill_145", "friends", nil, nil, 1, 1, 1 } } )
	end
	mismall = function()
		managers.job:activate_job ( "mallcrasher" )
		Global.game_settings.level_id = "mallcrasher"
		Global.game_settings.mission = managers.job:current_mission()
		Global.game_settings.difficulty = "overkill_145"
		local level_id = tweak_data.levels:get_index_from_level_id( Global.game_settings.level_id )
		local job_id = tweak_data.narrative:get_index_from_job_id( managers.job:current_job_id() )
		managers.network.matchmake:create_lobby( { numbers = { level_id, "overkill_145", "friends", nil, nil, 1, 1, 1 } } )
	end
	misclub = function()
		managers.job:activate_job ( "nightclub" )
		Global.game_settings.level_id = "nightclub"
		Global.game_settings.mission = managers.job:current_mission()
		Global.game_settings.difficulty = "overkill_145"
		local level_id = tweak_data.levels:get_index_from_level_id( Global.game_settings.level_id )
		local job_id = tweak_data.narrative:get_index_from_job_id( managers.job:current_job_id() )
		managers.network.matchmake:create_lobby( { numbers = { level_id, "overkill_145", "friends", nil, nil, 1, 1, 1 } } )
	end
	misjewel = function()
		managers.job:activate_job ( "jewelry_store" )
		Global.game_settings.level_id =  "jewelry_store"
		Global.game_settings.mission = managers.job:current_mission()
		Global.game_settings.difficulty = "overkill_145"
		local level_id = tweak_data.levels:get_index_from_level_id( Global.game_settings.level_id )
		local job_id = tweak_data.narrative:get_index_from_job_id( managers.job:current_job_id() )
		managers.network.matchmake:create_lobby( { numbers = { level_id, "overkill_145", "friends", nil, nil, 1, 1, 1 } } )
	end
	misukr = function()
		managers.job:activate_job ( "ukrainian_job_prof" )
		Global.game_settings.level_id = "ukrainian_job"
		Global.game_settings.mission = managers.job:current_mission()
		Global.game_settings.difficulty = "overkill_145"
		local level_id = tweak_data.levels:get_index_from_level_id( Global.game_settings.level_id )
		local job_id = tweak_data.narrative:get_index_from_job_id( managers.job:current_job_id() )
		managers.network.matchmake:create_lobby( { numbers = { job_id, "overkill_145", "friends", nil, nil, 1, 1, 1 } } )
	end
	missafe = function()
		managers.job:activate_job ( "ukrainian_job_prof" )
		Global.game_settings.level_id = "safehouse"
		Global.game_settings.mission = managers.job:current_mission()
		Global.game_settings.difficulty = "overkill_145"
		local level_id = tweak_data.levels:get_index_from_level_id( Global.game_settings.level_id )
		local job_id = tweak_data.narrative:get_index_from_job_id( managers.job:current_job_id() )
		managers.network.matchmake:create_lobby( { numbers = { job_id, "overkill_145", "public", nil, nil, 1, 1, 1 } } )
	end
	
	-- CREATE LOBBY FOR ESCAPE MISSIONS
	escapecafe = function()
		managers.job:activate_job ( "ukrainian_job" )
		Global.game_settings.level_id = "escape_cafe"
		Global.game_settings.mission = managers.job:current_mission()
		Global.game_settings.difficulty = "normal"
		local level_id = tweak_data.levels:get_index_from_level_id( Global.game_settings.level_id )
		local job_id = tweak_data.narrative:get_index_from_job_id( managers.job:current_job_id() )
		managers.network.matchmake:create_lobby( { numbers = { level_id, "overkill_145", "friends", nil, nil, 1, 1, 1 } } )
	end
	escapecafe2 = function()
	managers.job:set_next_interupt_stage( "escape_cafe" )
	end
	escapecafeday = function()
		managers.job:activate_job ( "ukrainian_job" )
		Global.game_settings.level_id = "escape_cafe_day"
		Global.game_settings.mission = managers.job:current_mission()
		Global.game_settings.difficulty = "normal"
		local level_id = tweak_data.levels:get_index_from_level_id( Global.game_settings.level_id )
		local job_id = tweak_data.narrative:get_index_from_job_id( managers.job:current_job_id() )
		managers.network.matchmake:create_lobby( { numbers = { level_id, "overkill_145", "friends", nil, nil, 1, 1, 1 } } )
	end
	escapecafeday2 = function()
	managers.job:set_next_interupt_stage( "escape_cafe_day" )
	-- Global.game_settings.level_id = "escape_cafe_day" --TESTSHIT
	end
	escapepark = function()
		managers.job:activate_job ( "ukrainian_job" )
		Global.game_settings.level_id = "escape_park"
		Global.game_settings.mission = managers.job:current_mission()
		Global.game_settings.difficulty = "normal"
		local level_id = tweak_data.levels:get_index_from_level_id( Global.game_settings.level_id )
		local job_id = tweak_data.narrative:get_index_from_job_id( managers.job:current_job_id() )
		managers.network.matchmake:create_lobby( { numbers = { level_id, "overkill_145", "friends", nil, nil, 1, 1, 1 } } )
	end
	escapepark2 = function()
	managers.job:set_next_interupt_stage( "escape_park" )
	end
	escapeparkday = function()
		managers.job:activate_job ( "ukrainian_job" )
		Global.game_settings.level_id = "escape_park_day"
		Global.game_settings.mission = managers.job:current_mission()
		Global.game_settings.difficulty = "normal"
		local level_id = tweak_data.levels:get_index_from_level_id( Global.game_settings.level_id )
		local job_id = tweak_data.narrative:get_index_from_job_id( managers.job:current_job_id() )
		managers.network.matchmake:create_lobby( { numbers = { level_id, "overkill_145", "friends", nil, nil, 1, 1, 1 } } )
	end
	escapeparkday2 = function()
	managers.job:set_next_interupt_stage( "escape_park_day" )
	end
	escapeovp = function()
		managers.job:activate_job ( "ukrainian_job" )
		Global.game_settings.level_id = "escape_overpass"
		Global.game_settings.mission = managers.job:current_mission()
		Global.game_settings.difficulty = "normal"
		local level_id = tweak_data.levels:get_index_from_level_id( Global.game_settings.level_id )
		local job_id = tweak_data.narrative:get_index_from_job_id( managers.job:current_job_id() )
		managers.network.matchmake:create_lobby( { numbers = { level_id, "overkill_145", "friends", nil, nil, 1, 1, 1 } } )
	end
	escapeovp2 = function()
	managers.job:set_next_interupt_stage( "escape_overpass" )
	end
	escapeovpnight = function()
		managers.job:activate_job ( "ukrainian_job" )
		Global.game_settings.level_id = "escape_overpass_night"
		Global.game_settings.mission = managers.job:current_mission()
		Global.game_settings.difficulty = "normal"
		local level_id = tweak_data.levels:get_index_from_level_id( Global.game_settings.level_id )
		local job_id = tweak_data.narrative:get_index_from_job_id( managers.job:current_job_id() )
		managers.network.matchmake:create_lobby( { numbers = { level_id, "overkill_145", "friends", nil, nil, 1, 1, 1 } } )
	end
	escapeovpnight2 = function()
	managers.job:set_next_interupt_stage( "escape_overpass_night" )
	end
	escapestreet = function()
		managers.job:activate_job ( "ukrainian_job" )
		Global.game_settings.level_id = "escape_street"
		Global.game_settings.mission = managers.job:current_mission()
		Global.game_settings.difficulty = "normal"
		local level_id = tweak_data.levels:get_index_from_level_id( Global.game_settings.level_id )
		local job_id = tweak_data.narrative:get_index_from_job_id( managers.job:current_job_id() )
		managers.network.matchmake:create_lobby( { numbers = { level_id, "overkill_145", "friends", nil, nil, 1, 1, 1 } } )
	end
	escapestreet2 = function()
	managers.job:set_next_interupt_stage( "escape_street" )
	end
	escapegarage = function()
		managers.job:activate_job ( "ukrainian_job" )
		Global.game_settings.level_id = "escape_garage"
		Global.game_settings.mission = managers.job:current_mission()
		Global.game_settings.difficulty = "normal"
		local level_id = tweak_data.levels:get_index_from_level_id( Global.game_settings.level_id )
		local job_id = tweak_data.narrative:get_index_from_job_id( managers.job:current_job_id() )
		managers.network.matchmake:create_lobby( { numbers = { level_id, "overkill_145", "friends", nil, nil, 1, 1, 1 } } )
	end
	escapegarage2 = function()
	managers.job:set_next_interupt_stage( "escape_garage" )
	end
	
	-- ARMOURED TRANSPORT DLC MAPS
	mistrain = function()
		managers.job:activate_job ( "ukrainian_job" )
		Global.game_settings.level_id = "arm_for"
		Global.game_settings.mission = managers.job:current_mission()
		Global.game_settings.difficulty = "overkill_145"
		local level_id = tweak_data.levels:get_index_from_level_id( Global.game_settings.level_id )
		local job_id = tweak_data.narrative:get_index_from_job_id( managers.job:current_job_id() )
		managers.network.matchmake:create_lobby( { numbers = { job_id, "overkill_145", "friends", nil, nil, 1, 1, 1 } } )
	end
	mishcm = function()
		managers.job:activate_job ( "arm_hcm" )
		Global.game_settings.level_id = "arm_hcm"
		Global.game_settings.mission = managers.job:current_mission()
		Global.game_settings.difficulty = "overkill_145"
		local level_id = tweak_data.levels:get_index_from_level_id( Global.game_settings.level_id )
		local job_id = tweak_data.narrative:get_index_from_job_id( managers.job:current_job_id() )
		managers.network.matchmake:create_lobby( { numbers = { job_id, "overkill_145", "friends", nil, nil, 1, 1, 1 } } )
	end
	miscro = function()
		managers.job:activate_job ( "arm_cro" )
		Global.game_settings.level_id = "arm_cro"
		Global.game_settings.mission = managers.job:current_mission()
		Global.game_settings.difficulty = "overkill_145"
		local level_id = tweak_data.levels:get_index_from_level_id( Global.game_settings.level_id )
		local job_id = tweak_data.narrative:get_index_from_job_id( managers.job:current_job_id() )
		managers.network.matchmake:create_lobby( { numbers = { job_id, "overkill_145", "friends", nil, nil, 1, 1, 1 } } )
	end
	misfac = function()
		managers.job:activate_job ( "arm_fac" )
		Global.game_settings.level_id = "arm_fac"
		Global.game_settings.mission = managers.job:current_mission()
		Global.game_settings.difficulty = "overkill_145"
		local level_id = tweak_data.levels:get_index_from_level_id( Global.game_settings.level_id )
		local job_id = tweak_data.narrative:get_index_from_job_id( managers.job:current_job_id() )
		managers.network.matchmake:create_lobby( { numbers = { job_id, "overkill_145", "friends", nil, nil, 1, 1, 1 } } )
	end
	mispar = function()
		managers.job:activate_job ( "arm_par" )
		Global.game_settings.level_id = "arm_par"
		Global.game_settings.mission = managers.job:current_mission()
		Global.game_settings.difficulty = "overkill_145"
		local level_id = tweak_data.levels:get_index_from_level_id( Global.game_settings.level_id )
		local job_id = tweak_data.narrative:get_index_from_job_id( managers.job:current_job_id() )
		managers.network.matchmake:create_lobby( { numbers = { job_id, "overkill_145", "friends", nil, nil, 1, 1, 1 } } )
	end
	misund = function()
		managers.job:activate_job ( "arm_und" )
		Global.game_settings.level_id = "arm_und"
		Global.game_settings.mission = managers.job:current_mission()
		Global.game_settings.difficulty = "overkill_145"
		local level_id = tweak_data.levels:get_index_from_level_id( Global.game_settings.level_id )
		local job_id = tweak_data.narrative:get_index_from_job_id( managers.job:current_job_id() )
		managers.network.matchmake:create_lobby( { numbers = { job_id, "overkill_145", "friends", nil, nil, 1, 1, 1 } } )
	end
	misanta = function()
		managers.job:activate_job ( "roberts" )
		Global.game_settings.level_id = "roberts"
		Global.game_settings.mission = managers.job:current_mission()
		Global.game_settings.difficulty = "overkill_145"
		local level_id = tweak_data.levels:get_index_from_level_id( Global.game_settings.level_id )
		local job_id = tweak_data.narrative:get_index_from_job_id( managers.job:current_job_id() )
		managers.network.matchmake:create_lobby( { numbers = { job_id, "overkill_145", "friends", nil, nil, 1, 1, 1 } } )
	end
	
	alterjob = alterjob or function()
		dofiles("trainer/assets/alternatejobmenu.lua")
	end
	
end
----------------
-- GAME --
----------------

if inGame() then

	mistrain3 = mistrain3 or function()
		managers.job:set_next_interupt_stage( "arm_for" )
		local num_winners = managers.network:game():amount_of_alive_players()
		managers.network:session():send_to_peers( "mission_ended", true, num_winners )
		game_state_machine:change_state_by_name( "victoryscreen", { num_winners = num_winners, personal_win = true } )
	end
	
	-- INSTANT WIN
	jobwin = jobwin or function()
		if Network:is_server() then
			if managers.platform:presence() == "Playing" then
				local num_winners = managers.network:game():amount_of_alive_players()
				managers.network:session():send_to_peers( "mission_ended", true, num_winners )
				game_state_machine:change_state_by_name( "victoryscreen", { num_winners = num_winners, personal_win = true } )
			end
		else
			show_mid_text("you noob....", "HOST ONLY", 2 )
			PlayMedia("trainer/media/effects/access.mp3")
		end
	end
	-- INSTANT LOSS
	jobloss = jobloss or function()
		if managers.platform:presence() == "Playing" and Network:is_server() then
			managers.network:session():send_to_peers( "mission_ended", false, 0 )
			game_state_machine:change_state_by_name( "gameoverscreen" )
			PlayMediaQueued("trainer/media/effects/youguyssuck.mp3")
		else
			show_mid_text("you noob....", "HOST ONLY", 2 )
		end
	end
	joblossq = joblossq or function()
		if managers.platform:presence() == "Playing" and Network:is_server() then
			managers.network:session():send_to_peers( "mission_ended", false, 0 )
			game_state_machine:change_state_by_name( "gameoverscreen" )
		else
			show_mid_text("you noob....", "HOST ONLY", 2 )
		end
	end
	-- SAFE ESCAPE
	function unlock_asset( asset_id )
		local asset = managers.assets:_get_asset_by_id( asset_id )
		jobsafeescape = jobsafeescape or function()
			if asset then
				if Network:is_server() and not managers.assets:get_asset_triggered_by_id( asset_id ) then
					managers.assets:server_unlock_asset( asset_id )
				elseif not managers.assets:get_asset_unlocked_by_id( asset_id ) then
					managers.network:session():send_to_host( "server_unlock_asset", asset_id )
				end
				asset.show = true
			else
				table.insert( managers.assets._global.assets, { id=asset_id, unlocked=true, show=true, can_unlock=false } )
			end
		managers.assets:init_finalize()
		managers.menu_component:create_asset_mission_briefing_gui()
		end
	unlock_asset("safe_escape")
	PlayMediaQueued("trainer/media/effects/evacok.mp3")
	end

	getemall = getemall or function()
		if inGame() and not isPlaying() then
			for _,asset_id in pairs (managers.assets:get_all_asset_ids( true )) do
				managers.assets:unlock_asset( asset_id )
			end
		end
	end
	
	got1ai = got1ai or function()
		dofiles("trainer/assets/ai1.lua")
	end
	got3ai = got3ai or function()
		dofiles("trainer/assets/ai3.lua")
	end

	--CHAIN LEVELS
	chainoil1 = chainoil1 or function()
		managers.job:set_next_interupt_stage( "welcome_to_the_jungle_1" )
	end
	chainoil2 = chainoil2 or function()
		managers.job:set_next_interupt_stage( "welcome_to_the_jungle_2" )
	end
	chainframe1 = chainframe1 or function()
		managers.job:set_next_interupt_stage( "framing_frame_1" )
	end
	chainframe2 = chainframe2 or function()
		managers.job:set_next_interupt_stage( "framing_frame_2" )
	end
	chainframe3 = chainframe3 or function()
		managers.job:set_next_interupt_stage( "framing_frame_3" )
	end
	chainelection1 = chainelection1 or function()
		managers.job:set_next_interupt_stage( "election_day_1" )
	end
	chainelection2 = chainelection2 or function()
		managers.job:set_next_interupt_stage( "election_day_2" )
	end
	chainelection3 = chainelection3 or function()
		managers.job:set_next_interupt_stage( "election_day_3" )
	end
	chainwatch1 = chainwatch1 or function()
		managers.job:set_next_interupt_stage( "watchdogs_1" )
	end
	chainwatch2 = chainwatch2 or function()
		managers.job:set_next_interupt_stage( "watchdogs_2" )
	end
	chainrats1 = chainrats1 or function()
		managers.job:set_next_interupt_stage( "alex_1" )
	end
	chainrats2 = chainrats2 or function()
		managers.job:set_next_interupt_stage( "alex_2" )
	end
	chainrats3 = chainrats3 or function()
		managers.job:set_next_interupt_stage( "alex_3" )
	end
	chainfire1 = chainfire1 or function()
		managers.job:set_next_interupt_stage( "firestarter_1" )
	end
	chainfire2 = chainfire2 or function()
		managers.job:set_next_interupt_stage( "firestarter_2" )
	end
	chainfire3 = chainfire3 or function()
		managers.job:set_next_interupt_stage( "firestarter_3" )
	end
	chainukrain = chainukrain or function()
		managers.job:set_next_interupt_stage( "ukrainian_job" )
	end
	chainjewel = chainjewel or function()
		managers.job:set_next_interupt_stage( "jewelry_store" )
	end
	chainfour = chainfour or function()
		managers.job:set_next_interupt_stage( "four_stores" )
	end
	chainmall = chainmall or function()
		managers.job:set_next_interupt_stage( "mallcrasher" )
	end
	chainnight = chainnight or function()
		managers.job:set_next_interupt_stage( "nightclub" )
	end
	chainbbank1 = chainbbank1 or function()
		managers.job:activate_job ( "branchbank_gold_prof" )
		managers.job:set_next_interupt_stage( "branchbank" )
	end
	chainbbank2 = chainbbank2 or function()
		managers.job:activate_job ( "branchbank_cash" )
		managers.job:set_next_interupt_stage( "branchbank" )
	end
	chainbbank3 = chainbbank3 or function()
		managers.job:activate_job ( "branchbank_deposit" )
		managers.job:set_next_interupt_stage( "branchbank" )
	end
	chainbbank4 = chainbbank4 or function()
		managers.job:activate_job ( "branchbank_prof" )
		managers.job:set_next_interupt_stage( "branchbank" )
	end
	chainfirst = chainfirst or function()
		managers.job:set_next_interupt_stage( "fwb" )
	end
	chainrobs = chainrobs or function()
		managers.job:set_next_interupt_stage( "roberts" )
	end
	chainfamily = chainfamily or function()
		managers.job:set_next_interupt_stage( "family" )
	end
	chainsafe = chainsafe or function()
		managers.job:set_next_interupt_stage( "safehouse" )
	end
	chainsafehaunt = chainsafehaunt or function()
		managers.job:set_next_interupt_stage( "haunted" )
	end
	chainarmtrans1 = chainarmtrans1 or function()
		managers.job:set_next_interupt_stage( "arm_fac" )
	end
	chainarmtrans2 = chainarmtrans2 or function()
		managers.job:set_next_interupt_stage( "arm_par" )
	end
	chainarmtrans3 = chainarmtrans3 or function()
		managers.job:set_next_interupt_stage( "arm_hcm" )
	end
	chainarmtrans4 = chainarmtrans4 or function()
		managers.job:set_next_interupt_stage( "arm_for" )
	end
	chainarmtrans5 = chainarmtrans5 or function()
		managers.job:set_next_interupt_stage( "arm_cro" )
	end
	chainarmtrans6 = chainarmtrans6 or function()
		managers.job:set_next_interupt_stage( "arm_und" )
	end
	chainontime1 = chainontime1 or function()
		managers.job:set_next_interupt_stage( "on_time_1" )
	end
	chainontime2 = chainontime2 or function()
		managers.job:set_next_interupt_stage( "on_time_2" )
	end
	chainbig = chainbig or function()
		managers.job:set_next_interupt_stage( "big" )
	end
	--[[	"election_day_3_skip1", "election_day_3_skip2"	]]--
	
	dropintel = dropintel or function()
		dofiles("trainer/assets/dropintel.lua")
	end
	loadaioptions = loadaioptions or function()
		dofiles("trainer/assets/aioptions.lua")
	end
	noescapetimer = noescapetimer or function()
		dofiles("trainer/assets/noescapetimer.lua")
	end
	
	makeitnormal = makeitnormal or function()
		Global.game_settings.difficulty = "normal"
	end
	makeithard = makeithard or function()
		Global.game_settings.difficulty = "hard"
	end
	makeitveryhard = makeitveryhard or function()
		Global.game_settings.difficulty = "overkill"
	end
	makeitoverkill = makeitoverkill or function()
		Global.game_settings.difficulty = "overkill_145"
	end
	makeitdeathwish = makeitdeathwish or function()
		Global.game_settings.difficulty = "overkill_290"
	end

end

----------------
-- MENU --
----------------
callescapemenu = function()
    openmenu(escapemenu)
end
callescapemenu2 = function()
    openmenu(escapemenu2)
end
calldirlevelmenu = function()
    openmenu(dirlevelmenu)
end
calldirlevelmenu2 = function()
    openmenu(dirlevelmenu2)
end
calldirlevelmenu3 = function()
    openmenu(dirlevelmenu3)
end
calljobrootmenuo = function()
    openmenu(jobrootmenuo)
end
calljobrootmenui = function()
    openmenu(jobrootmenui)
end
callchainmulti = function()
    openmenu(chainmenu)
end
callchainsingle = function()
    openmenu(chainmenu2)
end
callchainarmtran = function()
    openmenu(chainmenu3)
end
chainunknown = function()
    openmenu(chainmenu4)
end
opendifficultymenu = function()
    openmenu(difficultymenu)
end
chainopt1 = chainopt1 or {
	{ text = "返回", callback = calljobrootmenui },
	{ text = "", is_cancel_button = true},	
	{ text = "石油大亨第1天", callback = chainoil1 },
	{ text = "石油大亨第2天", callback = chainoil2 },
	{},
	{ text = "看门狗第1天", callback = chainwatch1 },
	{ text = "看门狗第2天", callback = chainwatch2 },
	{},
	{ text = "偷天换日第1天", callback = chainframe1 },
	{ text = "偷天换日第2天", callback = chainframe2 },
	{ text = "偷天换日第3天", callback = chainframe3 },
	{},
	{ text = "纵火者第1天", callback = chainfire1 },
	{ text = "纵火者第2天", callback = chainfire2 },
	{ text = "纵火者第3天", callback = chainfire3 },
	{},
	{ text = "鼠辈第1天", callback = chainrats1 },
	{ text = "鼠辈第2天", callback = chainrats2 },
	{ text = "鼠辈第3天", callback = chainrats3 },
	{},
	{ text = "选举日第1天", callback = chainelection1 },
	{ text = "选举日第2天-投票", callback = chainelection2 },
	{ text = "选举日第3天-银行", callback = chainelection3 },
	}
chainmenu = chainmenu or SimpleMenu:new("CHAIN MISSION SELECTOR", ".. multi-day missions", chainopt1)	
chainopt2 = chainopt2 or {
	{ text = "返回", callback = calljobrootmenui },
	{ text = "", is_cancel_button = true},	
	{ text = "银行劫案 - 保险柜", callback = chainbbank3 },
	{ text = "银行劫案 - 专业", callback = chainbbank4 },
	{ text = "银行劫案 - 现金", callback = chainbbank2 },
	{ text = "银行劫案 - 黄金", callback = chainbbank1 },
	{},
	{ text = "乌克兰的买卖", callback = chainsafe },
	--{ text = "Safehouse - Haunted house", callback = chainsafehaunt },
	{},
	{ text = "商场拆迁队", callback = chainmall },
	{},
	{ text = "夜总会", callback = chainnight },
	{},
	{ text = "四家商店", callback = chainfour },
	{},
	{ text = "珠宝店", callback = chainjewel },
	{ text = "Jewelry store - Ukrainian job (PRO)", callback = chainukrain },
	{},
	{ text = "钻石商店", callback = chainfamily },
	{},
	{ text = "去银行", callback = chainrobs },
	}
chainmenu2 = chainmenu2 or SimpleMenu:new("CHAIN MISSION SELECTOR", ".. single-day missions", chainopt2)	
--
chainopt3 = chainopt3 or {
	{ text = "返回", callback = calljobrootmenui },
	{ text = "", is_cancel_button = true},	
	{ text = "市中心", callback = chainarmtrans3 },
	{ text = "十字路口", callback = chainarmtrans5 },
	{ text = "海港", callback = chainarmtrans1 },
	{ text = "公园", callback = chainarmtrans2 },
	{ text = "地下通道", callback = chainarmtrans6 },
	{},
	{ text = "火车劫案", callback = chainarmtrans4 },
	}
chainmenu3 = chainmenu3 or SimpleMenu:new("CHAIN MISSION SELECTOR", ".. Choose DLC mission", chainopt3)
chainopt4 = chainopt4 or {
	{ text = "返回", callback = calljobrootmenui },
	{ text = "", is_cancel_button = true},	
	{ text = "Big", callback = chainbig },
	{ text = "第一次世界银行", callback = chainfirst },
	{ text = "准时", callback = chainontime1 },
	{ text = "准时 2", callback = chainontime2 },
	}
chainmenu4 = chainmenu4 or SimpleMenu:new("DONT EXPECT THIS SHIT TO WORK", ".. yet", chainopt4)
difficultyoptions = difficultyoptions or {
	{ text = "返回", callback = calljobrootmenui },
	{ text = "", is_cancel_button = true},	
	{ text = "正常", callback = makeitnormal },
	{ text = "困难", callback = makeithard },
	{ text = "非常困难", callback = makeitveryhard },
	{ text = "枪林弹雨", callback = makeitoverkill },
	{ text = "死亡之愿", callback = makeitdeathwish },
	}
difficultymenu = difficultymenu or SimpleMenu:new("CHANGE MISSION DIFFICULTY", ".. needs mission restart to kick in", difficultyoptions)
-- -- ESCAPE MENU INGAME
-- escapeopt2 = escapeopt2 or {
	-- { text = "返回", callback = calljobrootmenui },
	-- { text = "", is_cancel_button = true},	
	-- { text = "街道逃脱", callback = escapestreet2 },
	-- { text = "车库逃脱", callback = escapegarage2 },
	-- { text = "咖啡馆逃脱 白天", callback = escapecafeday2 },
	-- { text = "咖啡馆逃脱 夜晚", callback = escapecafe2 },
	-- { text = "公园逃脱 白天", callback = escapeparkday2 },
	-- { text = "公园逃脱 夜晚", callback = escapepark2 },
	-- { text = "立交桥逃脱 白天", callback = escapeovp2 },
	-- { text = "立交桥逃脱 夜晚", callback = escapeovpnight2 },
	-- -- { text = "火车劫案", callback = mistrain3 },
	-- }
-- escapemenu2 = escapemenu2 or SimpleMenu:new("CHAIN ESCAPE MISSION", "...Pitstop?", escapeopt2)	
-- MISSION SELECTOR MULTIDAY
dirlevelopt = dirlevelopt or {
	{ text = "返回", callback = calljobrootmenuo },
	{ text = "", is_cancel_button = true},	
	{ text = "石油大亨第1天", callback = misbigoil },
	{ text = "石油大亨第2天", callback = misbigoil2 },
	{},
	{ text = "看门狗第1天", callback = miswatch },
	{ text = "看门狗第2天", callback = miswatch2 },
	{},
	{ text = "偷天换日第1天", callback = misframe },
	{ text = "偷天换日第2天", callback = misframe2 },
	{ text = "偷天换日第3天", callback = misframe3 },
	{},
	{ text = "纵火者第1天", callback = misfire },
	{ text = "纵火者第2天", callback = misfire2 },
	{ text = "纵火者第3天", callback = misfire3 },
	{},
	{ text = "鼠辈第1天", callback = misrats },
	{ text = "鼠辈第2天", callback = misrats2 },
	{ text = "鼠辈第3天", callback = misrats3 },
	{},
	{ text = "选举日第1天", callback = miselect },
	{ text = "选举日第2天-投票", callback = miselect2 },
	{ text = "选举日第3天-银行", callback = miselect3 },
	}
dirlevelmenu = dirlevelmenu or SimpleMenu:new("OVERKILL MISSION SELECTOR", ".. multi-day missions", dirlevelopt)	
dirlevelopt2 = dirlevelopt2 or {
	{ text = "返回", callback = calljobrootmenuo },
	{ text = "", is_cancel_button = true},	
	{ text = "银行劫案 - 保险柜", callback = misbankd },
	{ text = "银行劫案 - 专业", callback = misbanks },
	{ text = "银行劫案 - 现金", callback = misbankc },
	{ text = "银行劫案 - 黄金", callback = misbankg },
	{},
	{ text = "乌克兰的买卖", callback = missafe },
	{},
	{ text = "商场拆迁队", callback = mismall },
	{},
	{ text = "夜总会", callback = misclub },
	{},
	{ text = "四家商店", callback = misfour },
	{},
	{ text = "珠宝店", callback = misjewel },
	{ text = "乌兰克买卖", callback = misukr },
	{},
	{ text = "钻石商店", callback = misfamily },
	{},
	{ text = "去银行", callback = misanta },
	}
dirlevelmenu2 = dirlevelmenu2 or SimpleMenu:new("OVERKILL MISSION SELECTOR", ".. single-day missions", dirlevelopt2)	
dirlevelopt3 = dirlevelopt3 or {
	{ text = "返回", callback = calljobrootmenuo },
	{ text = "", is_cancel_button = true},	
	{ text = "市中心", callback = mishcm },
	{ text = "十字路口", callback = miscro },
	{ text = "海港", callback = misfac },
	{ text = "公园", callback = mispar },
	{ text = "地下通道", callback = misund },
	{},
	{ text = "火车劫案", callback = mistrain },
	}
dirlevelmenu3 = dirlevelmenu3 or SimpleMenu:new("ARMOURED TRANSPORT DLC MISSION SELECTOR", ".. Choose DLC mission", dirlevelopt3)	
escapeopt = escapeopt or {
	{ text = "返回", callback = calljobrootmenuo },
	{ text = "", is_cancel_button = true},	
	{ text = "街道逃脱", callback = escapestreet },
	{ text = "车库逃脱", callback = escapegarage },
	{ text = "咖啡馆逃脱 白天", callback = escapecafeday },
	{ text = "咖啡馆逃脱 夜晚", callback = escapecafe },
	{ text = "公园逃脱 白天", callback = escapeparkday },
	{ text = "公园逃脱 夜晚", callback = escapepark },
	{ text = "立交桥逃脱 白天", callback = escapeovp },
	{ text = "立交桥逃脱 夜晚", callback = escapeovpnight },
	}
escapemenu = escapemenu or SimpleMenu:new("选择逃脱任务", " ", escapeopt)
jobrootopto = jobrootopto or {
	{ text = "一天的任务菜单", callback = calldirlevelmenu2 },
	{ text = "多天的任务菜单", callback = calldirlevelmenu },
	--{ text = "任务菜单", callback = callescapemenu },
	{ text = "装甲运输DLC任务菜单", callback = calldirlevelmenu3 },
	{},
	{ text = "免费购买合约", callback = freejob },
	--{ text = "合同菜单", callback = alterjob },
	{},
	{ text = "Exit", is_cancel_button = true},	
	{},
	{ text = "随机添加潜入合约", callback = randomstealth },
	{ text = "添加所有专家级合约", callback = addonlyproffmis },
	{},
	{ text = "添家所有正常难度合约", callback = addnormmis },
	{ text = "添加所有困难难度合约", callback = addhardmis },
	{ text = "添加所有非常困难难度合约", callback = addvhardmis },
	{ text = "添加所有枪林弹雨难度合约", callback = addovermis },
	{ text = "添加所有死亡愿望难度合约", callback = addhellrmis },
	}
jobrootopti = jobrootopti or {
	{ text = "立即失败", callback = jobloss },
	{ text = "立即胜利", callback = jobwin },
	{},
	--{ text = "改变难度", callback = opendifficultymenu },
	{},
	{ text = "退出", is_cancel_button = true},
	{},
	{ text = "未知使命菜单", callback = chainunknown },
	{ text = "火车劫案(仅限主机)", callback = dropintel },
	{},
	{ text = "装甲运输任务菜单", callback = callchainarmtran },
	{ text = "的单天的任务菜单", callback = callchainsingle },
	{ text = "多天的任务菜单", callback = callchainmulti },
	--{ text = "逃脱任务菜单", callback = callescapemenu2 }, --DISABLED UPD 1.7.1
	}
-- PREGAME MENU
jobrootoptp = jobrootoptp or {
	--{ text = "AI设定[菜单\ ]", callback = loadaioptions },
	--{},
	--{ text = "3个AI", callback = got3ai },
	--{ text = "1个AI", callback = got1ai },
	--{},
	{ text = "退出", is_cancel_button = true},
	--{},
	--{ text = "没有逃脱计时器", callback = noescapetimer },
	{},
	{ text = "解锁所有的有利條件", callback = getemall },
	
	}
if not jobrootmenuo then
	jobrootmenuo = jobrootmenuo or SimpleMenu:new("工作菜单", "...今天我们要做什么?", jobrootopto)
end
if not jobrootmenui then
	jobrootmenui = jobrootmenui or SimpleMenu:new("工作菜单", " ", jobrootopti)
end
if not jobrootmenup then
	jobrootmenup = jobrootmenup or SimpleMenu:new("工作菜单", "马上开始", jobrootoptp)
end

if not inGame() then 
	jobrootmenuo:show()
elseif inGame() and not isPlaying() then
	jobrootmenup:show()
elseif inGame() and isPlaying() then
	jobrootmenui:show()
end
